                                                
/*
**  Snapshot Format Definitions.
**
**  Copyright 1993-2000 by Paul D. Burgin. All rights reserved.
*/
                                                 
/* Defines for values used to denote PAK format versions. */
#define V1_2	0x12
#define V1_3	0x13
#define V1_4	0x14

/* Signature for PC-Dragon compressed snapshot files. */
#define COMPRESSED_SIG	0xfff5

/* PAK format structure definitions...... */

/* Extra information used only by PC-Dragon (all denoted pcd_). */

/* Informational, essential and debugger options. */
struct pcd_info
{
	unsigned char	pcd_pak_data1[2];

	/* Informational items. */
	unsigned int	pcd_signature;
	unsigned char	pcd_checksum;
	unsigned char	pcd_pak_version;
	unsigned char	pcd_ext_version;
	unsigned char	pcd_emu_version;
	unsigned char	pcd_state_only;
	unsigned char	pcd_arch;
	unsigned char	pcd_rom_start;

	/* Machine state. */
	unsigned int	pcd_irq_cycles;
	unsigned char	pcd_screen_size;
	unsigned char	pcd_pias[9];
	unsigned char	pcd_last_shift;
	unsigned char	pcd_filemem[8];

	/* Debugger. */
	unsigned int	pcd_last_text_base;
	unsigned int	pcd_breakpoints[6];
	unsigned int	pcd_break_op;
	unsigned int	pcd_diss_pcr;
	unsigned int	pcd_fill_start;
	unsigned int	pcd_fill_end;
	unsigned char	pcd_fill_value;
	unsigned char	pcd_left_window;
	unsigned int	pcd_temp_break;
	unsigned int	pcd_breakvalue;
	unsigned char	pcd_brk_control;
	unsigned char	pcd_breaktype;
	unsigned int	pcd_intern;
	unsigned int	pcd_dump_address;
}; /* 66 of 66 bytes */

/* PC-Dragon options. */
struct pcd_options
{
	unsigned char	pcd_pak_data2[65];

	unsigned char	pcd_bitpack1;
	unsigned char	pcd_back_ary;
	unsigned char	pcd_fore_ary;
	unsigned char	pcd_vmode_ary[2][2][6];
	unsigned char	pcd_border_ary[2][2];

	unsigned char   pcd_pak_data3;

	unsigned int	pcd_irq_rate;
	unsigned char	pcd_service_mem[16];
	unsigned char	pcd_comspeed;
	unsigned char	pcd_lpt_and_swapping;
	unsigned char	pcd_hardjoy_resolution;
}; /* 118 of 128 bytes */

/* Jeff Vavasour's 6809 snapshot format. */
/* Different pak_part's used for different .PAK format versions. */

/* All versions. */
typedef struct
{
	unsigned char	snap_name[33];
} pak_part1;

/* V1.2 only. */
typedef struct
{
	unsigned char	debug_dump_flag;
	unsigned char	debug_disassemble_reg;
	unsigned int	debug_dump_address;
} pak_part2;

/* All versions. */
typedef struct
{
	unsigned int	snap_pcr;
	unsigned int	snap_x;
	unsigned int	snap_y;
	unsigned int	snap_u;
	unsigned int	snap_s;
	unsigned char	snap_zero1;
	unsigned char	snap_dp;
	unsigned char	snap_b;
	unsigned char	snap_a;
} pak_part3;

/* V1.2 only. */
typedef struct
{
	unsigned char	debug_unknown[2];
} pak_part4;

/* All versions. */
typedef struct
{
	unsigned int	snap_8086_flags;
	unsigned char	snap_6809_flags;
} pak_part5a;

/* All versions except V1.4. */
typedef struct
{
	unsigned int	snap_low32k_read_seg;
	unsigned int	snap_low32k_write_seg;
	unsigned int	snap_high32k_read_seg;
	unsigned int	snap_high32k_write_seg;
} pak_part5b;

/* Version V1.4 only. */
typedef struct
{
	unsigned char	snap_new_page_status;
	unsigned char	snap_new_rom_status;
	unsigned char	snap_new_ff02;
	unsigned char	snap_new_ff03;
	unsigned char	snap_new_ff22;
} pak_part5c;

/* All versions. */
typedef struct
{
	unsigned int	snap_video_base1;
	unsigned int	snap_video_end1;
} pak_part5d;

/* All versions (but comes BEFORE pak_part5a in V1.4). */
typedef struct
{
	unsigned char	snap_zero2[6];
} pak_part5e;

/* All versions. */
typedef struct
{
	unsigned char	snap_write_protect;
	union
	{
		unsigned char		snap_disk_directory[66];
		struct pcd_info		pi;
	} u1;
	union
	{
		unsigned char		snap_disk_name[4][32];
		struct pcd_options	po;
	} u2;
	unsigned char	snap_pak_directory[66];
	unsigned char	snap_crlf;
	unsigned char	snap_keyboard_mode;
	unsigned int	snap_speed;
	unsigned char	snap_left_joystick;
	unsigned char	snap_right_joystick;
	unsigned int	snap_lower_case;
	unsigned char	snap_sound;
	unsigned char	snap_artifact;
	unsigned char	snap_dragon_rom;
} pak_part5;

/* V1.4 only. */
typedef struct
{
	unsigned int	snap_joystick_limits[8];
	unsigned int	snap_clock;
	unsigned char	snap_drive_mode;
	unsigned char	snap_volume;
	unsigned char	snap_cas_mode;
	unsigned char	snap_cas_directory[66];
	unsigned char	snap_cas_name[33];
} pak_part6;

/* All versions except V1.4. */
typedef struct
{
	unsigned char	snap_zero4[4]; /* Jeff says 6! */
	unsigned int	snap_video_base2;
	unsigned int	snap_video_end2;
	unsigned int	snap_zero5;
	unsigned char	snap_ff22;
	unsigned char	snap_ff02;
	unsigned char	snap_ff03;
} pak_part7;

/* Overall snapshot format structure. */
typedef struct
{
	pak_part1		p1;
	pak_part2		p2;
	pak_part3		p3;
	pak_part4		p4;
	pak_part5a		p5a;
	pak_part5b		p5b;
	pak_part5c		p5c;
	pak_part5d		p5d;
	pak_part5e		p5e;
	pak_part5		p5;
	pak_part6		p6;
	pak_part7		p7;
} pak_format;

