                                                                       
/*
**  Macros For Flag Setting, 16-bit Memory Access & Operand Fetch Or Set.
**
**  Copyright 1993-2000 by Paul D. Burgin. All rights reserved.
*/

/* 8 bit 'n' and 'z' flag setting function. */
#define set_nz8(tq)	\
		z_flag = (tq == 0);\
		n_flag = (tq >> 7)

/* 16 bit 'n' and 'z' flag setting function. */
#define set_nz16(tq)	\
		z_flag = (tq == 0);\
		n_flag = ((tq >> 15) & 1)

/* 8 bit addition 'v' flag setting function. */
#define set_va8(carry,vl,va)	\
		mac8 = ((vl) & 0x7f) + ((va) & 0x7f) + carry;\
		v_flag = (c_flag ^ (mac8 >> 7));\
		h_flag = ((vl) & 0x0f) + ((va) & 0x0f) + carry;\
		h_flag >>= 4

/* 16 bit addition 'v' flag setting function. */
#define set_va16(vl,va)	\
		mac16 = ((vl) & 0x7fff) + ((va) & 0x7fff);\
		v_flag = (c_flag ^ (mac16 >> 15))

/* 8 bit subtraction 'v' flag setting function. */
#define set_vs8(carry,vl,va)	\
		mac8 = ((vl) & 0x7f) - (((va) & 0x7f) + carry);\
		v_flag = (c_flag ^ (mac8 >> 7))

/* 16 bit subtraction 'v' flag setting function. */
#define set_vs16(vl,va)	\
		mac16 = ((vl) & 0x7fff) - ((va) & 0x7fff);\
		v_flag = (c_flag ^ (mac16 >> 15))

/* Integer memory fetch function. */
#define get_mem16(adds)	\
		((get_mem8(adds) << 8) | get_mem8(adds + 1))

/* Integer memory setting function. */
#define set_mem16(adds, val16)	\
		set_mem8(adds, val16 >> 8);\
		set_mem8(adds+1, val16 & 0x00ff)

/* Combine individual flags to mimic cc register. */
#define get_cc_reg()	((e_flag << 7) | (f_flag << 6)\
							| (h_flag << 5) | (i_flag << 4)\
							| (n_flag << 3) | (z_flag << 2)\
							| (v_flag << 1)	| (c_flag))

/* Fetch 8 bit operand from source specified by instruction. */
#define get8()	\
{\
	switch(__r)\
	{\
		case TO_MEM:	v8 = get_mem8(addr); break;\
		default:		v8 = reg8_->u_value;\
	}\
}

/* Place 8 bit operand at destination specified by instruction. */
#define set8()	\
{\
	switch(__r)\
	{\
		case TO_MEM:	set_mem8(addr, v8); break;\
		default:		reg8_->u_value = v8;\
	}\
}

/* Fetch 8 bit operand from source specified by instruction (tfr/exg). */
#define exg_get8()	\
{\
	switch (__r)\
	{\
		case A_REG:\
		case B_REG:\
		case DP_REG:	v16 = 0xff00 | (unsigned int)reg8_->u_value;\
						break;\
		case CC_REG:	v16 = 0xff00 | (unsigned int)get_cc_reg();\
						break;\
		default:		v16 = 0xffff;\
						break;\
	}\
}

/* Place 8 bit operand at destination specified by instruction (tfr/exg). */
#define exg_set8()	\
{\
	switch (__r)\
	{\
		case A_REG:\
		case B_REG:\
		case DP_REG:	reg8_->u_value = v8;\
						break;\
		case CC_REG:	far_set_cc_reg(v8);\
						break;\
	}\
}

/* Setup pointer to implicit register and define data size. */
#define set_reg()	\
{\
	__b = B8;\
	if (__r < TO_MEM)\
		__b = B16;\
	reg8_ = (reg8 *)(reg16_ = reg_table[__r]);\
}

/* bioskey(1) replacement. */
#define iskey()				((key_buf > 0) || bioskey(1))

