              
/*
 * LFN2.C
 *
 * This file contains function _lfn_fullpath() which is not available
 * in the main LFN library.
 */

/* DOSEMU */

#include <string.h>
#include <stdlib.h>		/* _fullpath() */
#include <dos.h>		/* struct REGPACK, intr, FP_SEG, FP_OFF */
#include <stdio.h>		/* (lfn.h) */
#include <dir.h>		/* (lfn.h) */

#include "lfn.h"

#if !defined(LFN95)
#error LFN2.C should only be used for building MS-DOS applications!
#endif

/* Begin inclusion... */
#define CFLAG	1

/*********************
 * Private Functions *
 ********************/

/*
 * Find short equivalent to long filename by calling int 21h function
 * 7160h.
 */
static int bFindShortName(struct REGPACK *pstRegs, char *szShort, const char *szLong)
{
	pstRegs->r_ax = 0x7160;
	pstRegs->r_cx = 0x0001;
	pstRegs->r_ds = FP_SEG((void far *)szLong);
	pstRegs->r_si = FP_OFF((void far *)szLong);
	pstRegs->r_es = FP_SEG((void far *)szShort);
	pstRegs->r_di = FP_OFF((void far *)szShort);
	intr(0x21, pstRegs);
	return((pstRegs->r_flags & CFLAG) == 0);
}
/* ...end of inclusion. */

/********************
 * Public Functions *
 ********************/

/* _lfn_fullpath() is a direct replacement for _fullpath(). */
char *_lfn_fullpath(char *szBuffer, const char *szLongPath, int iBufLen)
{
	struct REGPACK	stRegs;
	char			szShortPath[MAXPATH];

	/* Use Windows 95/98 long filename services if available. */
	if (lfn_is95())
	{
		if (bFindShortName(&stRegs, szShortPath, szLongPath))
		{
			/* Found file with specified name - so return it. */
			if (szBuffer == NULL)
				return(strdup(szShortPath));

			if (strlen(szShortPath) >= iBufLen)
				return(NULL);

			strcpy(szBuffer, szShortPath);
			return(szBuffer);
		}
	}

	/* If Windows 95/98 not available then pass request to C runtime. */
	return(_fullpath(szBuffer, szLongPath, iBufLen));
}
