                                                  
/*
 * LFN.H
 *
 * Important: Include all standard headers before this one.
 */
                                            
#define LFN_MAJOR	1
#define LFN_MINOR	0
#define LFN_VERSION	((LFN_MAJOR << 8) | LFN_MINOR)

#if !defined(LFN95) && !defined(WIN32)
#if defined(__MSDOS__) || defined(WIN16)
#define LFN95
#endif
#endif

/* LFN_MAXPATH is a direct replacement for MAXPATH or similar. */
#if defined(LFN95) || defined(WIN32)
#define LFN_MAXPATH	260
#elif defined(MAXPATH)
#define LFN_MAXPATH	MAXPATH
#elif defined(MAX_PATH)
#define LFN_MAXPATH	MAX_PATH
#elif defined(PATH_MAX)
#define LFN_MAXPATH	PATH_MAX
#elif defined(MAXPATHLEN)
#define LFN_MAXPATH	MAXPATHLEN
#else
#define LFN_MAXPATH	LFN_DEFMAXPATH
#endif

/* lfn_is95() returns 1 if running under Windows 95/98. */
extern int lfn_is95(void);

/* lfn_fopen() is a direct replacement for fopen(). */
extern FILE *lfn_fopen(const char *szLongName, const char *szMode);

/* lfn_freopen() is a direct replacement for freopen(). */
extern FILE *lfn_freopen(const char *szLongName, const char *szMode, FILE *pstStream);

#if defined(LFN95) || defined(WIN32)
/* _lfn_fsopen() is a direct replacement for _fsopen(). */
extern FILE *_lfn_fsopen(const char *szLongName, const char *szMode, int iShFlg);
#endif

/* lfn_access() is a direct replacement for access(). */
extern int lfn_access(const char *szLongName, int iMode);

/* lfn_chdir() is a direct replacement for chdir(). */
extern int lfn_chdir(const char *szLongPath);

/* lfn_stat() is a direct replacement for stat(). */
extern int lfn_stat(char *szLongPath, /* struct stat */ void *szStatBuf);

/* lfn_remove() is a direct replacement for remove(). */
extern int lfn_remove(const char *szLongName);

/* lfn_unlink() is a direct replacement for unlink(). */
#define lfn_unlink(szLongName) lfn_remove(szLongName);

/* lfn_mkdir() is a direct replacement for mkdir(). */
#if defined(LFN95) || defined(WIN32)
extern int lfn_mkdir(const char *szLongPath);
#else
extern int lfn_mkdir(const char *szLongPath, int iMode);
#endif

/* lfn_rmdir() is a direct replacement for rmdir(). */
extern int lfn_rmdir(const char *szLongPath);

/* lfn_chmod() is a direct replacement for chmod(). */
extern int lfn_chmod(const char *szLongPath, int iMode);

/* lfn_rename() is a direct replacement for rename(). */
extern int lfn_rename(const char *szOldName, const char *szNewName);
