                                                  
/*
**  Public Definitions And Build Options.
**
**  Copyright 1993-2000 by Paul D. Burgin. All rights reserved.
*/
                               
#ifdef __MSDOS__
#ifndef __MEDIUM__
#error PC-Dragon must be compiled in the MEDIUM memory model.
#endif
#endif

/* Version definitions. */
#define VER_MAJOR	2
#define VER_MINOR	6
#define BETA		""

/* Define the desired registration level setting here.     */
/* (Need to recompile title.c for changes to take effect). */
/*  1 = Unregistered (obsolete)                            */
/*  2 = Freeware                                           */
/*  3 = Registered                                         */
#define REG_LEVEL	2

/* Define STRIPY here for column highlighting in memory dump. */
#define STRIP

/* Define BUGFIX here whilst the setgraphmode() bug persists.    */
/* (This is a bug in the Borland compiler V3.1).                 */
/* The fix causes initgraph() to be called every time the Dragon */
/* switches from text mode to graphics mode.                     */
#define BUGFIX

/* Define MOTOROLA here for machines with MSB/LSB architecture. */
#define MOTOROL

/* How many reads from $FF00 before keyboard cleared, and how long dead. */
/* (This is for pseudo 'Real Mode' keyboard emulation).                  */
/* Use 12,2 for ALLDREAM.                                                */
/* Try 10,0 for OS9.                                                     */
#define KEY_SCAN_RESOLUTION 12
#define KEY_SCAN_DEADBAND   2

/* How many IRQs before keyboard cleared, in the absense of $FF00 reads. */
/* (This is for pseudo-hardware keyboard emulation).                     */
/* Usually 11.                                                           */
#define KEY_SCAN_RESET		11

/* How many IRQ's before joystick button can be updated. */
#define BUTTON_RESOLUTION	1

/* How many reads from $FF00 before joystick position updated.         */
/* This does not apply when the joystick is read via a ROM breakpoint. */
#define HARDJOY_RESOLUTION	28

/* How many IRQ's before change of emulated video mode is performed. */
#define REFRESH_RESOLUTION	3

/* Length of user definable keyboard macros. */
#define PRESET_LEN			64

/* Default number of cycles between IRQ interrupts. */
#define D_IRQ_RATE	17800U

/* Miscellaneous memory definitions. */
#define UNMAPPED	0x7e	  /* Value returned by unmapped memory.      */
#define ROM_START	0x8000	  /* RAM/ROM boundary (may be decreased).    */
#define MEMORY_SIZE	0xffef    /* Malloc size for page 0 (do not change). */

/* Rogue value for unused breakpoint addresses. */
#define NOBREAKPOINT		0xffff

/* Addresses for internal workspace. */
#define JOY_BUTTON			0xff1f /* 1 byte  */
#define TEMPJOY				0xff2b /* 4 bytes */
#define MATRIX				0xff30 /* 9 bytes */
#define I_DATA				0xffbe /* 2 bytes */
#define SNAP_JUNK			0xffc0 /* 1 byte */

/* PC interrupt numbers. */
#define JOYSTICK_INT		0x15
#define MOUSE_INT			0x33

/* Key press for control menu. */
#define CONTROL_MENU		0x42

/* Code for first UDG character. */
#define UDG_FIRST			208
