#include  "Types.h"
#ifdef USE_LOG
#include  "Log.h"
#endif
#include  "Z80.h"

#ifdef USE_ROMPLUS

#define     SEEKBACK    0x1000

#define     MAXSTRING   256

#define     MAX_BUF 0x4000


static int Matches[ 256 ];
static int MachTable[ 256 ][ SEEKBACK ];

static UBYTE BufOut[ MAX_BUF ];
static UBYTE BufIn[ MAX_BUF ];


static int Depack( UBYTE * InBuf, UBYTE * OutBuf )
{
    UBYTE a, DepackBits = 0;
    int Bit, InBytes = 0, Longueur, Delta, OutBytes = 0;

    for ( ;; )
        {
        Bit = DepackBits & 1;
        DepackBits >>= 1;
        if ( !DepackBits )
            {
            DepackBits = InBuf[ InBytes++ ];
            Bit = DepackBits & 1;
            DepackBits >>= 1;
            DepackBits |= 0x80;
            }
        if ( ! Bit )
            OutBuf[ OutBytes++ ] = InBuf[ InBytes++ ];
        else
            {
            if ( ! InBuf[ InBytes ] )
                break; /* EOF */

            a = InBuf[ InBytes ];
            if ( a & 0x80 )
                {
                Longueur = 3 + ( ( InBuf[ InBytes ] >> 4 ) & 7 );
                Delta = ( InBuf[ InBytes++ ] & 15 ) << 8;
                Delta |= InBuf[ InBytes++ ];
                Delta++;
                }
            else
                if ( a & 0x40 )
                    {
                    Longueur = 2;
                    Delta = InBuf[ InBytes++ ] & 0x3f;
                    Delta++;
                    }
                else
                    if ( a & 0x20 )
                        {
                        Longueur = 2 + ( InBuf[ InBytes++ ] & 31 );
                        Delta = InBuf[ InBytes++ ];
                        Delta++;
                        }
                    else
                        if ( a & 0x10 )
                            {
                            Delta = ( InBuf[ InBytes++ ] & 15 ) << 8;
                            Delta |= InBuf[ InBytes++ ];
                            Longueur = InBuf[ InBytes++ ] + 1;
                            Delta++;
                            }
                        else
                            {
                            if ( InBuf[ InBytes ] == 15 )
                                {
                                Longueur = Delta = InBuf[ InBytes+1 ] + 1;
                                InBytes += 2;
                                }
                            else
                                {
                                if ( InBuf[ InBytes ] > 1 )
                                    Longueur = Delta = InBuf[ InBytes ];
                                else
                                    Longueur = Delta = 256;

                                InBytes++;
                                }
                            }
            for ( ; Longueur--; )
                {
                OutBuf[ OutBytes ] = OutBuf[ OutBytes - Delta ];
                OutBytes++;
                }
            }
        }
    return( OutBytes );
}


static int Pack( int Longueur )
{
    UBYTE CodeBuffer[ 24 ];
    UBYTE Bits = 0;
    int Count = 0, BitCount = 0, CodeCount = 0;
    int MachTableStart = 0, MatchTableEnd = 0, OldMatchTableStart;
    int c, Taille = 0;

    memset( Matches, 0, sizeof( Matches ) );
    for( ;; )
        {
        for ( c = MatchTableEnd; c < Count; c++ )
            {
            int b = BufIn[ c ];
            MachTable[ b ][ Matches[ b ] ] = c;
            Matches[ b ]++;
            }
        MatchTableEnd = Count;

        if ( Count >= 2 )
            {
            int StLen = 0;
            int StPos = 0;
            int StLen2 = 0;
            int bb = BufIn[ Count ];
            for ( c = Matches[ bb ] - 1; c >= 0; c-- )
                {
                int start = MachTable[ bb ][ c ];
                int end = start + MAXSTRING;
                if ( end > Count )
                    end = Count;

                if ( end - start >= StLen )
                    {
                    int max = end - start;
                    int d;

                    for ( d = 1; d < max; d++ )
                        if ( BufIn[ start+d ] != BufIn[ Count+d ] ) 
                            break;

                    if ( ( d >= 2 ) && ( d > StLen ) )
                        {
                        StLen = d;
                        StPos = Count - start;
                        }
                    if ( ( d == StLen ) && ( Count - start < StPos ) )
                        StPos = Count - start;
                    }

                if ( ( StLen == MAXSTRING ) && ( StPos == StLen ) ) 
                    break;
                }
            if ( Count+1 < Longueur )
                {
                bb = BufIn[ Count + 1 ];
                for ( c = Matches[ bb ] - 1; c >= 0; c-- )
                    {
                    int start = MachTable[ bb ][ c ];
                    int end = start + MAXSTRING;
                    if ( end > Count+1 ) end = Count+1;

                    if ( end-start >= StLen2 )
                        {
                        int max = end - start;
                        int d;

                        for ( d = 1; d < max; d++ )
                            if ( BufIn[ start+d ] != BufIn[ Count+d+1 ] )
                                break;

                        if ( ( d >= 2 ) && ( d >= StLen2 ) )
                            StLen2 = d;
                        }
                    if ( StLen2 == MAXSTRING )
                        break;
                    }
                if ( StLen2 - 1 > StLen )
                    StLen = 0;
                }

            if ( StLen > 1 )
                {
                if ( ( StLen == 2 ) && ( StPos >= 256 ) )
                    {
                    CodeBuffer[ CodeCount++ ] = BufIn[ Count++ ];
                    BitCount++;
                    }
                else
                    {
                    if ( StPos == StLen )
                        {
                        if ( StLen == MAXSTRING )
                            CodeBuffer[ CodeCount++ ] = 0x1;
                        else
                            {
                            if ( StLen <= 14 )
                                CodeBuffer[ CodeCount++ ] = StLen;
                            else
                                {
                                CodeBuffer[ CodeCount++ ] = 0xf;
                                CodeBuffer[ CodeCount++ ] = StLen - 1;
                                }
                            }
                        }
                    else
                        {
                        if ( ( StLen == 2 ) && ( StPos < 65 ) )
                            CodeBuffer[ CodeCount++ ] = 0x40 + StPos - 1;
                        else
                            {
                            if ( ( StLen <= 33 ) && ( StPos < 257 ) )
                                {
                                CodeBuffer[ CodeCount++ ] = 0x20 + StLen - 2;
                                CodeBuffer[ CodeCount++ ] = StPos - 1;
                                }
                            else
                                {
                                if ( ( StLen >= 3 ) && ( StLen <= 10 ) )
                                    {
                                    CodeBuffer[ CodeCount++ ] = 0x80 + ( ( StLen - 3 ) << 4 ) + ( ( StPos - 1 ) >> 8 );
                                    CodeBuffer[ CodeCount++ ] = ( StPos - 1 ) & 0xff;
                                    }
                                else
                                    {
                                    CodeBuffer[ CodeCount++ ] = 0x10 + ( ( StPos - 1 ) >> 8 );
                                    CodeBuffer[ CodeCount++ ] = ( StPos - 1 ) & 0xff;
                                    CodeBuffer[ CodeCount++ ] = StLen - 1;
                                    }
                                }
                            }
                        }
                    Bits |= 1 << BitCount;
                    BitCount++;
                    Count += StLen;
                    }
                }
            else
                {
                CodeBuffer[ CodeCount++ ] = BufIn[ Count++ ];
                BitCount++;
                }
            }
        else
            {
            CodeBuffer[ CodeCount++ ] = BufIn[ Count++ ];
            BitCount++;
            }
        if ( BitCount == 8 )
            {
            BufOut[ Taille++ ] = Bits;
            memcpy( &BufOut[ Taille ], CodeBuffer, CodeCount );
            Taille += CodeCount;
            BitCount = CodeCount = 0;
            Bits = 0;
            }
        if ( Count >= Longueur )
            break;

        OldMatchTableStart = MachTableStart;
        MachTableStart = Count - SEEKBACK;
        if ( MachTableStart < 0 )
            MachTableStart = 0;

        for ( c = OldMatchTableStart; c < MachTableStart; c++ )
            {
            int b = BufIn[ c ];
            int d;
            for ( d = 0; d < Matches[ b ]; d++ )
                if ( MachTable[ b ][ d ] >= MachTableStart )
                    {
                    memmove( &MachTable[ b ][ 0 ]
                           , &MachTable[ b ][ d ]
                           , ( Matches[ b ] - d ) * sizeof( int )
                           );
                    break;
                    }

            Matches[ b ] -= d;
            }
        }
    CodeBuffer[ CodeCount++ ] = 0;
    Bits |= 1 << BitCount;
    BufOut[ Taille++ ] = Bits;
    memcpy( &BufOut[ Taille ], CodeBuffer, CodeCount );
    Taille += CodeCount;
    return( Taille );
}


static void ConvertBuffScreen( UBYTE xDeb
                             , UBYTE yDeb
                             , UBYTE xFin
                             , UBYTE yFin
                             , int * Length
                             )
{
    static UBYTE BLigne[ 0x4000 ];
    int l, adr = 0, PosReel = 0;
    int NbOctets = xFin - xDeb + 1;

    * Length = 0;
    for ( l = 0; l < 200; l++ )
        {
        if ( l >= yDeb && l <= yFin )
            {
            memcpy( &BLigne[ PosReel ], &BufIn[ adr + xDeb ], NbOctets );
            PosReel += NbOctets;
            * Length += NbOctets;
            }
        adr += 0x800;
        if ( adr > 0x3FFF )
            adr = adr - 0x3FB0;
        }
    memcpy( BufIn, BLigne, * Length );
}


//
// Dtermine les coordonnes d'un objet affich  l'cran
//
static void FindBuffScreen( UBYTE * xDeb
                          , UBYTE * yDeb
                          , UBYTE * xFin
                          , UBYTE * yFin
                          )
{
    int adr = 0, l, oct;

    * xFin = 0;
    * xDeb = 79;
    * yDeb = 199;
    * yFin = 0;
    for ( l = 0; l < 200; l++ )
        {
        for ( oct = 0; oct < 80; oct++ )
            {
            if ( BufIn[ adr + oct ] )
                {
                if ( * xDeb > oct )
                    * xDeb = oct;

                if ( * xFin < oct )
                    * xFin = oct;

                if ( * yDeb > l )
                    * yDeb = l;

                if ( * yFin < l )
                    * yFin = l;
                }
            }
        adr += 0x800;
        if ( adr > 0x3FFF )
            adr = adr - 0x3FB0;
        }
}


//
// Copie une partie de la mmoire cpc vers un buffer
//
static void MemCpcToHost( USHORT AdrCpc, UBYTE * Buf, int Lg )
{
    for ( ; Lg--; )
        * Buf++ = Peek8Ext( AdrCpc++ );
}


//
// Copie un buffer vers une partie de la mmoire cpc
//
static void MemHostToCpc( UBYTE * Buf, USHORT AdrCpc, int Lg )
{
    for ( ; Lg--; )
        Poke8Ext( AdrCpc++, * Buf++ );
}


int PackScreen( USHORT Adr )
{
    int Longueur, lpack;

    MemCpcToHost( 0xC000, BufIn, 0x4000 );
    ConvertBuffScreen( 0, 0, 79, 199, &Longueur );
    lpack = Pack( Longueur );
    MemHostToCpc( BufOut, Adr, lpack );
    return( lpack );
}


int PackWindow( UBYTE xDeb, UBYTE yDeb, UBYTE xFin, UBYTE yFin, USHORT Adr )
{
    int Longueur, lpack;

    MemCpcToHost( 0xC000, BufIn, 0x4000 );
    ConvertBuffScreen( xDeb, yDeb, xFin, yFin, &Longueur );
    lpack = Pack( Longueur ) + 4;
    Poke8Ext( Adr++, xDeb );
    Poke8Ext( Adr++, yDeb );
    Poke8Ext( Adr++, xFin );
    Poke8Ext( Adr++, yFin );
    MemHostToCpc( BufOut, Adr, lpack );
    return( lpack );
}


int PackWinDC( USHORT Adr )
{
    int Longueur, lpack;
    UBYTE xDeb, yDeb, xFin, yFin;

    MemCpcToHost( 0xC000, BufIn, 0x4000 );
    FindBuffScreen( &xDeb, &yDeb, &xFin, &yFin );
#ifdef USE_LOG
    sprintf( MsgLog, "xDeb     = %d", xDeb );
    Log( MsgLog, LOG_DEBUG );
    sprintf( MsgLog , "yDeb     = %d", yDeb );
    Log( MsgLog, LOG_DEBUG );
    sprintf( MsgLog , "xFin     = %d", xFin );
    Log( MsgLog, LOG_DEBUG );
    sprintf( MsgLog , "yFin     = %d", yFin );
    Log( MsgLog, LOG_DEBUG );
#endif
    ConvertBuffScreen( xDeb, yDeb, xFin, yFin, &Longueur );
    lpack = Pack( Longueur ) + 4;
    Poke8Ext( Adr++, xDeb );
    Poke8Ext( Adr++, yDeb );
    Poke8Ext( Adr++, xFin );
    Poke8Ext( Adr++, yFin );
    MemHostToCpc( BufOut, Adr, lpack );
    return( lpack );
}


int DepackScreen( USHORT Adr )
{
    int Longueur, l, AdrCPC = 0, AdrHost = 0;

    MemCpcToHost( Adr, BufIn, 0x4000 );
    Longueur = Depack( BufIn, BufOut );
    for ( l = 0; l < 200; l++ )
        {
        MemHostToCpc( &BufOut[ AdrHost ]
                    , ( USHORT )( 0xC000 + AdrCPC )
                    , 80
                    );
        AdrHost += 80;
        AdrCPC += 0x800;
        if ( AdrCPC > 0x3FFF )
            AdrCPC = AdrCPC - 0x3FB0;
        }
    return( 0 );
}


int DepackWindow( USHORT Adr )
{
    int Longueur, l, AdrCPC = 0, AdrHost = 0;
    UBYTE xDeb, yDeb, xFin, yFin, NbX;

    xDeb = Peek8Ext( Adr++ );
    yDeb = Peek8Ext( Adr++ );
    xFin = Peek8Ext( Adr++ );
    yFin = Peek8Ext( Adr++ );
    NbX = xFin - xDeb + 1;
    MemCpcToHost( Adr, BufIn, 0x4000 );
    Longueur = Depack( BufIn, BufOut );
    for ( l = 0; l < 200; l++ )
        {
        if ( l >= yDeb && l <= yFin )
            {
            MemHostToCpc( &BufOut[ AdrHost ]
                        , ( USHORT )( 0xC000 + AdrCPC + xDeb )
                        , NbX
                        );
            AdrHost += NbX;
            }
        AdrCPC += 0x800;
        if ( AdrCPC > 0x3FFF )
            AdrCPC = AdrCPC - 0x3FB0;
        }
    return( 0 );
}


int PackBuffer( USHORT AdrSrc, USHORT Longueur, USHORT AdrDest )
{
    int lpack;

    MemCpcToHost( AdrSrc, BufIn, Longueur );
    lpack = Pack( Longueur );
    MemHostToCpc( BufOut, AdrDest, lpack );
    return( lpack );
}


int DepackBuffer( USHORT AdrSrc, USHORT AdrDest )
{
    int Longueur;
    
    MemCpcToHost( AdrSrc, BufIn, 0xFFFF - AdrSrc );
    Longueur = Depack( BufIn, BufOut );
    MemHostToCpc( BufOut, AdrDest, Longueur );
    return( Longueur );
}
#endif
