/*****************************************************************************
 *                                                                           *
 * Module : MAIN.C                                                           *
 *                                                                           *
 * Module principal, initialisations, gestion des vnements : clavier,      *
 * fermeture de la fentre (fin du prg.)                                     *
 *                                                                           *
 *****************************************************************************/


#include  <Intuition/Intuition.h>
#include  <Exec/Memory.h>
#include  <Proto/Intuition.h>
#include  <Proto/Graphics.h>
#include  <Proto/Exec.h>
#include  <String.h>
#include  <proto/dos.h>
#include  <proto/asl.h>
#include  <dos/dostags.h>
#include  <stdio.h>

#include  "z80.h"
#include  "vga.h"
#include  "upd.h"
#include  "ppi.h"
#include  "draw.h"
#include  "process.h"
#include  "Config.h"


#define HAUTEUR_ECRAN      256
#define TAILLE_PLAN        ( HAUTEUR_ECRAN * 80 )
#define POS_FENETRE        12
#define HAUTEUR_FENETRE    ( HAUTEUR_ECRAN - POS_FENETRE )
#define DECALAGE_ECRAN     POS_FENETRE * 80

#define STACK_SIZE 4000L        // taille de la pile pour la tache de fond
#define PRI           0         // priorit  


struct IntuitionBase * IntuitionBase;
struct GfxBase * GfxBase;
struct Library * AslBase;



UBYTE * plan0, * plan1, * plan2, * plan3, * plan4;

int finMain = 0;
int DmdChgFic = 0;
int Reset = 0;
extern int Turbo, VBL, IRQ, InterruptMode;

extern int RegsCRTC[ 32 ];

extern int OfsEcr, lastMode;

int CntHSync = 0;

struct Screen * Ecran;
struct RastPort rp;


//
// Structure clavier CPC
//
typedef struct
    {
    UBYTE PortA;        // Port A du ppi (colonne clavier)
    UBYTE Ligne;        // Numro de ligne clavier ( de 0  9 )
    } stToucheClav;


//
// Tableau de conversion des RAWKEYs AMIGA -> Touches CPC
//
static stToucheClav TabTouches[ 128 ] =
    {
    //
    //  un 0x0F dans le champ Ligne signifie une combinaison non utilise
    //  ( la rom infrieure ne lit que les lignes de 0  9 )
    //
        { 0xFF, 0x0F },       // RAW KEY CODE = 0x00    ---- 
        { 0xFE, 0x08 },       // RAW KEY CODE = 0x01    '1'
        { 0xFD, 0x08 },       // RAW KEY CODE = 0x02    '2'
        { 0xFD, 0x07 },       // RAW KEY CODE = 0x03    '3'
        { 0xFE, 0x07 },       // RAW KEY CODE = 0x04    '4'
        { 0xFD, 0x06 },       // RAW KEY CODE = 0x05    '5'
        { 0xFE, 0x06 },       // RAW KEY CODE = 0x06    '6'
        { 0xFD, 0x05 },       // RAW KEY CODE = 0x07    '7'
        { 0xFE, 0x05 },       // RAW KEY CODE = 0x08    '8'
        { 0xFD, 0x04 },       // RAW KEY CODE = 0x09    '9'
        { 0xFE, 0x04 },       // RAW KEY CODE = 0x0a    '0'
        { 0xFD, 0x03 },       // RAW KEY CODE = 0x0b    '='
        { 0xFE, 0x03 },       // RAW KEY CODE = 0x0c    ''
        { 0xBF, 0x02 },       // RAW KEY CODE = 0x0d    '\'
        { 0xFF, 0x0F },       // RAW KEY CODE = 0x0e    ----
        { 0x7F, 0x01 },       // RAW KEY CODE = 0x0f    F0
        { 0xF7, 0x08 },       // RAW KEY CODE = 0x10    'Q'
        { 0xF7, 0x07 },       // RAW KEY CODE = 0x11    'W'
        { 0xFB, 0x07 },       // RAW KEY CODE = 0x12    'E'
        { 0xFB, 0x06 },       // RAW KEY CODE = 0x13    'R'
        { 0xF7, 0x06 },       // RAW KEY CODE = 0x14    'T'
        { 0xF7, 0x05 },       // RAW KEY CODE = 0x15    'Y'
        { 0xFB, 0x05 },       // RAW KEY CODE = 0x16    'U'
        { 0xF7, 0x04 },       // RAW KEY CODE = 0x17    'I'
        { 0xFB, 0x04 },       // RAW KEY CODE = 0x18    'O'
        { 0xF7, 0x03 },       // RAW KEY CODE = 0x19    'P'
        { 0xFB, 0x03 },       // RAW KEY CODE = 0x1a    '@'
        { 0xFD, 0x02 },       // RAW KEY CODE = 0x1b    '['
        { 0xFF, 0x0F },       // RAW KEY CODE = 0x1c    ----
        { 0xDF, 0x01 },       // RAW KEY CODE = 0x1d    F1
        { 0xBF, 0x01 },       // RAW KEY CODE = 0x1e    F2
        { 0xDF, 0x00 },       // RAW KEY CODE = 0x1f    F3
        { 0xDF, 0x08 },       // RAW KEY CODE = 0x20    'A'
        { 0xEF, 0x07 },       // RAW KEY CODE = 0x21    'S'
        { 0xDF, 0x07 },       // RAW KEY CODE = 0x22    'D'
        { 0xDF, 0x06 },       // RAW KEY CODE = 0x23    'F'
        { 0xEF, 0x06 },       // RAW KEY CODE = 0x24    'G'
        { 0xEF, 0x05 },       // RAW KEY CODE = 0x25    'H'
        { 0xDF, 0x05 },       // RAW KEY CODE = 0x26    'J'
        { 0xDF, 0x04 },       // RAW KEY CODE = 0x27    'K'
        { 0xEF, 0x04 },       // RAW KEY CODE = 0x28    'L'
        { 0xDF, 0x03 },       // RAW KEY CODE = 0x29    '*'
        { 0xEF, 0x03 },       // RAW KEY CODE = 0x2a    '+'
        { 0xF7, 0x02 },       // RAW KEY CODE = 0x2b    ']'
        { 0xFF, 0x0F },       // RAW KEY CODE = 0x2c    ----
        { 0xEF, 0x02 },       // RAW KEY CODE = 0x2d    F4
        { 0xEF, 0x01 },       // RAW KEY CODE = 0x2e    F5
        { 0xEF, 0x00 },       // RAW KEY CODE = 0x2f    F6
        { 0xFF, 0x0F },       // RAW KEY CODE = 0x30    ---- 
        { 0x7F, 0x08 },       // RAW KEY CODE = 0x31    'Z'
        { 0x7F, 0x07 },       // RAW KEY CODE = 0x32    'X'
        { 0xBF, 0x07 },       // RAW KEY CODE = 0x33    'C'
        { 0x7F, 0x06 },       // RAW KEY CODE = 0x34    'V'
        { 0xBF, 0x06 },       // RAW KEY CODE = 0x35    'B'
        { 0xBF, 0x05 },       // RAW KEY CODE = 0x36    'N'
        { 0xBF, 0x04 },       // RAW KEY CODE = 0x37    'M'
        { 0x7F, 0x04 },       // RAW KEY CODE = 0x38    '<'
        { 0x7F, 0x03 },       // RAW KEY CODE = 0x39    '>'
        { 0xBF, 0x03 },       // RAW KEY CODE = 0x3a    '?'
        { 0xFF, 0x0F },       // RAW KEY CODE = 0x3b    ----
        { 0x7F, 0x00 },       // RAW KEY CODE = 0x3c    F'.'
        { 0xFB, 0x01 },       // RAW KEY CODE = 0x3d    F7
        { 0xF7, 0x01 },       // RAW KEY CODE = 0x3e    F8
        { 0xF7, 0x00 },       // RAW KEY CODE = 0x3f    F9
        { 0x7F, 0x05 },       // RAW KEY CODE = 0x40    ESPACE
        { 0x7F, 0x09 },       // RAW KEY CODE = 0x41    DEL
        { 0xEF, 0x08 },       // RAW KEY CODE = 0x42    TAB
        { 0xBF, 0x00 },       // RAW KEY CODE = 0x43    ENTER
        { 0xFB, 0x02 },       // RAW KEY CODE = 0x44    RETURN
        { 0xFB, 0x08 },       // RAW KEY CODE = 0x45    ESC
        { 0xFE, 0x02 },       // RAW KEY CODE = 0x46    CLR
        { 0xFF, 0x0F },       // RAW KEY CODE = 0x47    ----
        { 0xFF, 0x0F },       // RAW KEY CODE = 0x48    ----
        { 0xFF, 0x0F },       // RAW KEY CODE = 0x49    ----
        { 0xFF, 0x0F },       // RAW KEY CODE = 0x4a    ----
        { 0xFF, 0x0F },       // RAW KEY CODE = 0x4b    ----
        { 0xFE, 0x00 },       // RAW KEY CODE = 0x4c    Fleche Haut
        { 0xFB, 0x00 },       // RAW KEY CODE = 0x4d    Fleche Bas
        { 0xFD, 0x00 },       // RAW KEY CODE = 0x4e    Fleche Droite
        { 0xFE, 0x01 },       // RAW KEY CODE = 0x4f    Fleche Gauche
        { 0xFF, 0x0F },       // RAW KEY CODE = 0x50    ----
        { 0xFF, 0x0F },       // RAW KEY CODE = 0x51    ----
        { 0xFF, 0x0F },       // RAW KEY CODE = 0x52    ----
        { 0xFF, 0x0F },       // RAW KEY CODE = 0x53    ----
        { 0xFF, 0x0F },       // RAW KEY CODE = 0x54    ----
        { 0xFF, 0x0F },       // RAW KEY CODE = 0x55    ----
        { 0xFF, 0x0F },       // RAW KEY CODE = 0x56    ----
        { 0xFF, 0x0F },       // RAW KEY CODE = 0x57    ----
        { 0xFF, 0x0F },       // RAW KEY CODE = 0x58    ----
        { 0xFF, 0x0F },       // RAW KEY CODE = 0x59    ----
        { 0xFF, 0x0F },       // RAW KEY CODE = 0x5a    ----
        { 0xFF, 0x0F },       // RAW KEY CODE = 0x5b    ----
        { 0xFF, 0x0F },       // RAW KEY CODE = 0x5c    ----
        { 0xFF, 0x0F },       // RAW KEY CODE = 0x5d    ----
        { 0xFF, 0x0F },       // RAW KEY CODE = 0x5e    ----
        { 0xFF, 0x0F },       // RAW KEY CODE = 0x5f    ----
        { 0xDF, 0x02 },       // RAW KEY CODE = 0x60    SHIFT
        { 0xDF, 0x02 },       // RAW KEY CODE = 0x61    SHIFT
        { 0xBF, 0x08 },       // RAW KEY CODE = 0x62    CAPS LOCK
        { 0x7F, 0x02 },       // RAW KEY CODE = 0x63    CTRL
        { 0xFF, 0x0F },       // RAW KEY CODE = 0x64    ----
        { 0xFF, 0x0F },       // RAW KEY CODE = 0x65    ----
        { 0xFD, 0x01 },       // RAW KEY CODE = 0x66    COPY
        { 0xFF, 0x0F },       // RAW KEY CODE = 0x67    ----
        { 0xFF, 0x0F },       // RAW KEY CODE = 0x68    ----
        { 0xFF, 0x0F },       // RAW KEY CODE = 0x69    ----
        { 0xFF, 0x0F },       // RAW KEY CODE = 0x6a    ----
        { 0xFF, 0x0F },       // RAW KEY CODE = 0x6b    ----
        { 0xFF, 0x0F },       // RAW KEY CODE = 0x6c    ----
        { 0xFF, 0x0F },       // RAW KEY CODE = 0x6d    ----
        { 0xFF, 0x0F },       // RAW KEY CODE = 0x6e    ----
        { 0xFF, 0x0F },       // RAW KEY CODE = 0x6f    ----
        { 0xFF, 0x0F },       // RAW KEY CODE = 0x70    ----
        { 0xFF, 0x0F },       // RAW KEY CODE = 0x71    ----
        { 0xFF, 0x0F },       // RAW KEY CODE = 0x72    ----
        { 0xFF, 0x0F },       // RAW KEY CODE = 0x73    ----
        { 0xFF, 0x0F },       // RAW KEY CODE = 0x74    ----
        { 0xFF, 0x0F },       // RAW KEY CODE = 0x75    ----
        { 0xFF, 0x0F },       // RAW KEY CODE = 0x76    ----
        { 0xFF, 0x0F },       // RAW KEY CODE = 0x77    ----
        { 0xFF, 0x0F },       // RAW KEY CODE = 0x78    ----
        { 0xFF, 0x0F },       // RAW KEY CODE = 0x79    ----
        { 0xFF, 0x0F },       // RAW KEY CODE = 0x7a    ----
        { 0xFF, 0x0F },       // RAW KEY CODE = 0x7b    ----
        { 0xFF, 0x0F },       // RAW KEY CODE = 0x7c    ----
        { 0xFF, 0x0F },       // RAW KEY CODE = 0x7d    ----
        { 0xFF, 0x0F },       // RAW KEY CODE = 0x7e    ----
        { 0xFF, 0x0F }        // RAW KEY CODE = 0x7f    ----
    };


UBYTE finProc = 0;      // demande  la tache de fond de quitter


int __far TabPoints[ 4 ][ 256 ][ 8 ];


static void CalcPoints( void )
{
    int a, b, c, d, i;

    // Pour le mode 0
    for ( i = 0; i < 256; i++ )
        {
        a = ( ( i & 0x80 ) >> 7 ) + ( ( ( i & 0x20 ) >> 5 ) << 2 )
          + ( ( ( i & 0x08 ) >> 3 ) << 1 ) + ( ( ( i & 0x02 ) >> 1 ) << 3 );
        b = ( ( i & 0x40 ) >> 6 ) + ( ( ( i & 0x10 ) >> 4 ) << 2 )
          + ( ( ( i & 0x04 ) >> 2 ) << 1 ) + ( ( ( i & 0x01 ) ) << 3 );
        TabPoints[ 0 ][ i ][ 0 ] = ( char )a;
        TabPoints[ 0 ][ i ][ 1 ] = ( char )a;
        TabPoints[ 0 ][ i ][ 2 ] = ( char )a;
        TabPoints[ 0 ][ i ][ 3 ] = ( char )a;
        TabPoints[ 0 ][ i ][ 4 ] = ( char )b;
        TabPoints[ 0 ][ i ][ 5 ] = ( char )b;
        TabPoints[ 0 ][ i ][ 6 ] = ( char )b;
        TabPoints[ 0 ][ i ][ 7 ] = ( char )b;
        }

    // Pour le mode 1
    for ( i = 0; i < 256; i++ )
        {
        a = ( ( i & 0x80 ) >> 7 ) + ( ( ( i & 0x08 ) >> 3 ) << 1 );
        b = ( ( i & 0x40 ) >> 6 ) + ( ( ( i & 0x04 ) >> 2 ) << 1 );
        c = ( ( i & 0x20 ) >> 5 ) + ( ( ( i & 0x02 ) >> 1 ) << 1 );
        d = ( ( i & 0x10 ) >> 4 ) + ( ( ( i & 0x01 ) ) << 1 );
        TabPoints[ 1 ][ i ][ 0 ] = ( char )a;
        TabPoints[ 1 ][ i ][ 1 ] = ( char )a;
        TabPoints[ 1 ][ i ][ 2 ] = ( char )b;
        TabPoints[ 1 ][ i ][ 3 ] = ( char )b;
        TabPoints[ 1 ][ i ][ 4 ] = ( char )c;
        TabPoints[ 1 ][ i ][ 5 ] = ( char )c;
        TabPoints[ 1 ][ i ][ 6 ] = ( char )d;
        TabPoints[ 1 ][ i ][ 7 ] = ( char )d;
        }

    // Pour le mode 2
    for ( i = 0; i < 256; i++ )
        {
        TabPoints[ 2 ][ i ][ 0 ] = ( char )( ( i & 0x80 ) >> 7 );
        TabPoints[ 2 ][ i ][ 1 ] = ( char )( ( i & 0x40 ) >> 6 );
        TabPoints[ 2 ][ i ][ 2 ] = ( char )( ( i & 0x20 ) >> 5 );
        TabPoints[ 2 ][ i ][ 3 ] = ( char )( ( i & 0x10 ) >> 4 );
        TabPoints[ 2 ][ i ][ 4 ] = ( char )( ( i & 0x08 ) >> 3 );
        TabPoints[ 2 ][ i ][ 5 ] = ( char )( ( i & 0x04 ) >> 2 );
        TabPoints[ 2 ][ i ][ 6 ] = ( char )( ( i & 0x02 ) >> 1 );
        TabPoints[ 2 ][ i ][ 7 ] = ( char )( ( i & 0x01 ) );
        }

    // Mode 3 = Mode 0 ???
    for ( i = 0; i < 256; i++ )
        for ( a = 0; a < 8; a++ )
            TabPoints[ 3 ][ i ][ a ] = TabPoints[ 0 ][ i ][ a ];
}


//
// Fonction excute en tache de fond
//
static void ExecZ80( void )
{
    int FreqLigne = 256;//213;          // Nbre de cycles d'horloge Z80 
                                        // pour 1 ligne Tcran (a 3,3 Mhz)
    int DebutVSync = 0, NbLignesMax = 312, CntVSync = 0, CptInstr = 0;
    int TailleChar, TpsVbl = 0;

    do
        {
        CptInstr += ExecInstZ80();
        //
        // Gestion des compteurs : cycles d'horloges, VSync et HSync du CRTC
        //
        if ( CptInstr >= FreqLigne ) // Nbre de cycles = temps d'une ligne
            {
            //
            // Trace une ligne
            //
            CptInstr -= FreqLigne;
            if ( CntVSync < HAUTEUR_FENETRE )
                TraceLigne( CntVSync );

            CntVSync++;
            //
            // Si 52 lignes compte -> Gnration d'une interruption
            //
            if ( ++CntHSync == 52 )
                {
                IRQ = 1;
                CntHSync = 0;
                }
            //
            // Arriv en fin d'cran -> Raz de VSync
            //
            if ( CntVSync >= NbLignesMax )
                {
                //
                // Prise en compte des registres du format vertical du CRTC
                //
                TailleChar = RegsCRTC[ 9 ] + 1;
                CntVSync = 0;
                NbLignesMax = ( 1 + RegsCRTC[ 4 ] ) * TailleChar;
                DebutVSync = RegsCRTC[ 7 ] * TailleChar;
                Delay( 1 );
                }
            //
            // Si Compteur VSync = Position d'envoi du VBL...
            //
            if ( CntVSync == DebutVSync )
                TpsVbl = 0;

            //
            // Gnration du "Vertical Blanking Line"
            //
            VBL = ( TpsVbl++ < 32 );
            }
        }
    while( ! finProc );
}


/*
// Utilise un requester ASL pour slectionner un fichier
*/
static void SelectFichier( struct Screen * Ecran )
{
    /* Pour sauvegardes des derniers paramtres... */
    static char Repertoire[ 256 ] = { 0 };
    static char Fichier[ 256 ] = { 0 };
    static WORD LeftEdge = 170, TopEdge = 56, Width = 300, Height = 400;

    struct FileRequester * req;
    char nomFic[ 256 ];

//    if ( SetLowPri() )
        {
        WBenchToFront();
        req = ( struct FileRequester * )AllocAslRequest( ASL_FileRequest
                                                       , TAG_DONE 
                                                       );
        if ( req )
            {
            if ( AslRequestTags( req
                               , ASLFR_InitialPattern,  "#?.DSK"
                               , ASLFR_InitialFile,     Fichier
                               , ASLFR_InitialDrawer,   Repertoire
                               , ASLFR_InitialLeftEdge, LeftEdge
                               , ASLFR_InitialTopEdge,  TopEdge
                               , ASLFR_InitialWidth,    Width
                               , ASLFR_InitialHeight,   Height
                               , ASLFR_DoPatterns,      TRUE
                               , TAG_DONE
                               ) 
               )
                {
                /*
                // Extraction du nom du fichier et du rpertoire et mmorisation
                */
                strcpy( Repertoire, req->fr_Drawer );
                strcpy( Fichier, req->fr_File );
                strcpy( nomFic, Repertoire );
                if (  ( * nomFic )
                   && ( nomFic[ strlen( nomFic ) - 1 ] != ':' )
                   && ( nomFic[ strlen( nomFic ) - 1 ] != '/' )
                   )
                    strcat( nomFic, "/" );
                strcat( nomFic, req->fr_File );
                EjectDiskUPD();
//                ScreenToFront( Ecran );
                SetDiskUPD( nomFic );
                }
            /*
            // Mmorisation de la taille/position de la fentre du requester
            */
            LeftEdge = req->fr_LeftEdge;
            TopEdge  = req->fr_TopEdge;
            Width    = req->fr_Width;
            Height   = req->fr_Height;
            FreeAslRequest( ( APTR )req );
            }
        ScreenToFront( Ecran );
//        SetHighPri();
        }
}



//
// Fonction principale : lecture des venements...
//
static void GestionMessages( struct Window * Fenetre )
{
    struct IntuiMessage * message;
    BOOL fin = FALSE;
    UBYTE c;
    stToucheClav TrClav;


    memset( clav, -1, sizeof( clav ) );
    if ( AjouteTache( "ExecZ80", ExecZ80, -1 ) )
        {
        while ( ! fin )
            {
            //
            // Attente messages
            //
            WaitPort( Fenetre->UserPort );
            while ( message = ( struct IntuiMessage * )GetMsg( Fenetre->UserPort ) )
                {
                ReplyMsg( ( struct Message * )message );
                switch ( message->Class )
                    {
                    case CLOSEWINDOW : 
                        fin = TRUE;
                        finProc = 1;
                        break;

                    case RAWKEY :
                        //
                        // Gestion clavier -> transformation RAWKEY Amiga
                        // En code lignes et colonnes du CPC
                        //
                        c = message->Code;
                        TrClav = TabTouches[ c & 0x7F ];                

                        if ( c & 0x80 )
                            // Relachement
                            clav[ TrClav.Ligne ] |= ~TrClav.PortA;
                        else
                            // Appui
                            clav[ TrClav.Ligne ] &= TrClav.PortA;

                        switch( c )
                            {
                            case 0x56 :             /* touche F7 */
                                SelectFichier( Ecran );
                                break;

                            case 0x57 :             /* touche F8 */
                                ResetZ80();
//                              finProc = ETAT_RESET;
//                              while( finProc == ETAT_RESET )
//                                  Delay( 1 );
                                break;

                            case 0x59 :             /* touche F10 */
                                fin = TRUE;
                                finProc = 1;
                                break;
                            }
                     break;
                    }
                }
            }
        }
}


struct Screen * GetEcran( void )
{
    typedef struct
        {
        ULONG r;
        ULONG v;
        ULONG b;
        } stCouleur;

    static stCouleur Couleurs[ 32 ] =
        {
         0x7F,0x7F,0x7F,                 // Blanc            (13)
         0x7F,0x7F,0x7F,                 // Blanc            (13)
         0x00,0xFF,0x7F,                 // Vert Marin       (19)
         0xFF,0xFF,0x7F,                 // Jaune Pastel     (25)
         0x00,0x00,0x7F,                 // Bleu              (1)
         0xFF,0x00,0x7F,                 // Pourpre           (7)
         0x00,0x7F,0x7F,                 // Turquoise        (10)
         0xFF,0x7F,0x7F,                 // Rose             (16)
         0xFF,0x00,0x7F,                 // Pourpre           (7)
         0xFF,0xFF,0x00,                 // Jaune vif        (24)
         0xFF,0xFF,0x00,                 // Jaune vif        (24)
         0xFF,0xFF,0xFF,                 // Blanc Brillant   (26)
         0xFF,0x00,0x00,                 // Rouge vif         (6)
         0xFF,0x00,0xFF,                 // Magenta vif       (8)
         0xFF,0x7F,0x00,                 // Orange           (15)
         0xFF,0x7F,0xFF,                 // Magenta pastel   (17)
         0x00,0x00,0x7F,                 // Bleu              (1)
         0x00,0xFF,0x7F,                 // Vert Marin       (19)
         0x00,0xFF,0x00,                 // Vert vif         (18)
         0x00,0xFF,0xFF,                 // Turquoise vif    (20)
         0x00,0x00,0x00,                 // Noir              (0)
         0x00,0x00,0xFF,                 // Bleu vif          (2)
         0x00,0x7F,0x00,                 // Vert              (9)
         0x00,0x7F,0xFF,                 // Bleu ciel        (11)
         0x7F,0x00,0x7F,                 // Magenta           (4)
         0x7F,0xFF,0x7F,                 // Vert pastel      (22)
         0x7F,0xFF,0x00,                 // Vert citron      (21)
         0x7F,0xFF,0xFF,                 // Turquoise pastel (23)
         0x7F,0x00,0x00,                 // Rouge             (3)
         0x7F,0x00,0xFF,                 // Mauve             (5)
         0x7F,0x7F,0x00,                 // Jaune            (12)
         0x7F,0x7F,0xFF                  // Bleu pastel      (14)
        };

    static struct TextAttr topaz8 = { ( STRPTR )"topaz.font", 8, 0x00, 0x00 };

    static struct NewScreen e = 
        {
        0, 0, 640, 256, 5,
        0 , 1, 
        HIRES,
        CUSTOMSCREEN,
        &topaz8,
        0,
        0,
        0
        };

    struct Screen * Ecran;
    long i;

    e.DefaultTitle = "Ami-CPC C";
    Ecran = OpenScreen( &e );
    for ( i = 0; i < 32; i++ )
        SetRGB4( &Ecran->ViewPort
               , i
               , Couleurs[ i ].r >> 4
               , Couleurs[ i ].v >> 4
               , Couleurs[ i ].b >> 4
               );

    plan0 = Ecran->RastPort.BitMap->Planes[ 0 ] + DECALAGE_ECRAN;
    plan1 = Ecran->RastPort.BitMap->Planes[ 1 ] + DECALAGE_ECRAN;
    plan2 = Ecran->RastPort.BitMap->Planes[ 2 ] + DECALAGE_ECRAN;
    plan3 = Ecran->RastPort.BitMap->Planes[ 3 ] + DECALAGE_ECRAN;
    plan4 = Ecran->RastPort.BitMap->Planes[ 4 ] + DECALAGE_ECRAN;
    return( Ecran );
}


static void MyPrintf( char * Msg )
{
    Write( Output(), Msg, strlen( Msg ) );
}


static int OpenLibs( void )
{
    IntuitionBase = ( struct IntuitionBase * )OpenLibrary( "intuition.library", 36L );
    if ( IntuitionBase )
        {
        GfxBase = (struct GfxBase * )OpenLibrary( "graphics.library", 36L );
        if ( GfxBase )
            {
            if ( AslBase = OpenLibrary( "asl.library", 37L ) )
                return( 1 );
            else
                MyPrintf( "Erreur d'ouverture asl.library" );
            }
        else
            MyPrintf( "Erreur d'ouverture graphics.library" );
        }
    else
        MyPrintf( "Erreur d'ouverture intuition.library" );

    return( 0 );
}


static void CloseLibs( void )
{
    if ( IntuitionBase )
        CloseLibrary( ( struct Library * )IntuitionBase );

    if ( GfxBase )
        CloseLibrary( ( struct Library * )GfxBase );

    if ( AslBase )
        CloseLibrary( AslBase );
}


int main( void )
{
    struct NewWindow f =
        {
        0, POS_FENETRE, 640, HAUTEUR_FENETRE,
        0, 0,
        RAWKEY | CLOSEWINDOW | REFRESHWINDOW,
        ACTIVATE | WINDOWCLOSE | BACKDROP | BORDERLESS,
        0, 0, 0, 0, 0,
        0, 0, 0, 0,
        CUSTOMSCREEN
        };
    struct Window * Fenetre;
    static struct BitMap TmpBitmap;
    static UBYTE __far TmpMem[ 0x4000 ];

    MyPrintf( "Dmarrage CPC...\n" );
    StartLog( "Log_Emu_Cpc.txt" );
    if ( ReadConfig() )
        {
        if ( OpenLibs() )
            {
            if ( Ecran = GetEcran() )
                {
                f.Screen = Ecran;
                memcpy( &rp, &Ecran->RastPort, sizeof( rp ) );
                memcpy( &TmpBitmap, rp.BitMap, sizeof( TmpBitmap ) );
                TmpBitmap.Planes[ 0 ] = &TmpMem[ 0x0000 ];
                TmpBitmap.Planes[ 1 ] = &TmpMem[ 0x0800 ];
                TmpBitmap.Planes[ 2 ] = &TmpMem[ 0x1000 ];
                TmpBitmap.Planes[ 3 ] = &TmpMem[ 0x1800 ];
                TmpBitmap.Planes[ 4 ] = &TmpMem[ 0x2000 ];
                TmpBitmap.Planes[ 5 ] = &TmpMem[ 0x2800 ];
                TmpBitmap.Planes[ 6 ] = &TmpMem[ 0x3000 ];
                TmpBitmap.Planes[ 7 ] = &TmpMem[ 0x3800 ];
                TmpBitmap.Rows = 1;
                rp.Layer = NULL;
                rp.BitMap = &TmpBitmap;
                if ( Fenetre = OpenWindow( &f ) )
                    {
                    CalcPoints();
                    ResetUPD();
                    if ( AjouteTache( "Redraw", Redraw, -2 ) )
                        {
                        if ( InitMemCPC() )
                            {
                            GestionMessages( Fenetre );
                            }
                        else
                            MyPrintf( "Erreur initialisation mmoire cpc.\n" );

                        finProc = 1;
                        }
                    else
                        MyPrintf( "Erreur dmarrage process Redraw\n" );

                    CloseWindow( Fenetre );
                    EjectDiskUPD();
                    }
                else
                    MyPrintf( "Erreur ouverture fentre mulateur\n" );

                CloseScreen( Ecran );
                }
            else
                MyPrintf( "Erreur ouverture cran mulateur\n" );
            }
        else
            MyPrintf( "Erreur ouverture librairies\n" );
        }
    else
        MyPrintf( "Erreur lecture fichier de configuration\n" );

    Delay( 10 );
    CloseLibs();
    EndLog();
    return( 0 );
}
