#include  <Exec/types.h>
#include  <Intuition/Intuition.h>
#include  <proto/graphics.h>
#include  <Proto/Intuition.h>
#include  <Proto/Dos.h>
#include  <string.h>

#include  "z80.h"
#include "crtc.h"
#include  "vga.h"


#define HAUTEUR_ECRAN      256
#define TAILLE_PLAN        ( HAUTEUR_ECRAN * 80 )
#define POS_FENETRE        12
#define HAUTEUR_FENETRE    ( HAUTEUR_ECRAN - POS_FENETRE )
#define DECALAGE_ECRAN     POS_FENETRE * 80


extern int CptInstr, lastMode;

extern int __far TabPoints[ 4 ][ 256 ][ 8 ];

extern UBYTE finProc;

extern struct Screen * Ecran;
extern struct RastPort rp;

static UBYTE __far MemBitmap[ 640 * 256 ];


void Redraw( void )
{
    unsigned long y;

    while( ! finProc )
        {
        for ( y = 0; y < HAUTEUR_FENETRE; y++ )
            WritePixelLine8( &Ecran->RastPort
                            , 0
                            , y
                            , 640
                            , &MemBitmap[ y * 640 ]
                            , &rp
                            );
        }
}


void TraceLigne( int y )
{
    int x, adr = y * 80, pos = y * 640;
    UBYTE Border = TabCoul[ 16 ];
    unsigned short adCrtc;

    for ( x = 0; x < 80; x++, adr++ )
        {
        adCrtc = TabAdrCrtc[ adr ];
        if ( ! ( adCrtc & 0x8000 ) ) 
            {
            register int * ad = &TabPoints[ lastMode ][ MemCPC[ adCrtc + OfsEcr ] ][ 0 ];
            MemBitmap[ pos++ ] = TabCoul[ *ad++ ];
            MemBitmap[ pos++ ] = TabCoul[ *ad++ ];
            MemBitmap[ pos++ ] = TabCoul[ *ad++ ];
            MemBitmap[ pos++ ] = TabCoul[ *ad++ ];
            MemBitmap[ pos++ ] = TabCoul[ *ad++ ];
            MemBitmap[ pos++ ] = TabCoul[ *ad++ ];
            MemBitmap[ pos++ ] = TabCoul[ *ad++ ];
            MemBitmap[ pos++ ] = TabCoul[ *ad ];
            }
        else
            {
            MemBitmap[ pos++ ] = Border;
            MemBitmap[ pos++ ] = Border;
            MemBitmap[ pos++ ] = Border;
            MemBitmap[ pos++ ] = Border;
            MemBitmap[ pos++ ] = Border;
            MemBitmap[ pos++ ] = Border;
            MemBitmap[ pos++ ] = Border;
            MemBitmap[ pos++ ] = Border;
            }
        }
}
