#include  <windows.h>
#include  <stdio.h>

#include  "Types.h"
#include  "Z80.h"
#include  "Vga.h"
#include  "Pack.h"
#ifdef USE_LOG
#include  "log.h"
#endif


#ifdef USE_ROMPLUS
//
//  0C05
//
void SCR_NEXT_BYTE( void )
{
    RegL++;
    if ( ! RegL )
        {
        RegH++;
        if ( ! ( RegH & 7 ) )
            RegH -= 8;
        }
}


//
// 0C11
//
void SCR_PREV_BYTE( void )
{
    if ( ! RegL-- )
        {
        RegA = RegH;
        RegH--;
        if ( ! ( RegA & 7 ) )
            RegH += 8;
        }
}


//
// 0C1F
//
void SCR_NEXT_LINE( void )
{
}


//
// 0C39
//
void SCR_PREV_LINE( void )
{
    RegH -= 8;
    if ( ( RegH & 0x38 ) == 0x38 )
        {
        RegH += 0x40;
        RegA = RegL;
        RegL -= 0x50;
        if ( RegA < 0x50 )
            {
            RegA = RegH;
            RegH--;
            if ( ! ( RegA & 7 ) )
                RegH += 8;
            }
        }
}


int ED_01( void )
{
    int ad;

#ifdef USE_LOG
    Log( "ED_01 (PackScr)", LOG_DEBUG );
    sprintf( MsgLog , "DecodeurAdresse      = %d", DecodeurAdresse );
    Log( MsgLog, LOG_DEBUG );
    sprintf( MsgLog , "PC                   = 0x%04X", RegPC );
    Log( MsgLog, LOG_DEBUG );
    sprintf( MsgLog , "HL                   = 0x%04X", RegHL );
    Log( MsgLog, LOG_DEBUG );
    sprintf( MsgLog , "DE                   = 0x%04X", RegDE );
    Log( MsgLog, LOG_DEBUG );
    sprintf( MsgLog , "BC                   = 0x%04X", RegBC );
    Log( MsgLog, LOG_DEBUG );
    sprintf( MsgLog , "AF                   = 0x%04X", RegAF );
    Log( MsgLog, LOG_DEBUG );
    sprintf( MsgLog , "IX                   = 0x%04X", RegIX );
    Log( MsgLog, LOG_DEBUG );
#endif
    WriteVGA( DecodeurAdresse | ROMSUP_OFF );
    ad = PackScreen( RegHL );
    Poke8Ext( RegIX, ( UBYTE )ad );
    Poke8Ext( ( USHORT )( RegIX + 1 ), ( UBYTE )( ad >> 8 ) );
    WriteVGA( DecodeurAdresse );
    ___C9();
    return( 0 );
}


int ED_02( void )
{
    int ad;

#ifdef USE_LOG
    Log( "ED_02 (PackWin)", LOG_DEBUG );
    sprintf( MsgLog , "DecodeurAdresse      = %d", DecodeurAdresse );
    Log( MsgLog, LOG_DEBUG );
    sprintf( MsgLog , "PC                   = 0x%04X", RegPC );
    Log( MsgLog, LOG_DEBUG );
    sprintf( MsgLog , "HL                   = 0x%04X", RegHL );
    Log( MsgLog, LOG_DEBUG );
    sprintf( MsgLog , "B                    = 0x%04X", RegB );
    Log( MsgLog, LOG_DEBUG );
    sprintf( MsgLog , "C                    = 0x%04X", RegC );
    Log( MsgLog, LOG_DEBUG );
    sprintf( MsgLog , "D                    = 0x%04X", RegD );
    Log( MsgLog, LOG_DEBUG );
    sprintf( MsgLog , "E                    = 0x%04X", RegE );
    Log( MsgLog, LOG_DEBUG );
    sprintf( MsgLog , "AF                   = 0x%04X", RegAF );
    Log( MsgLog, LOG_DEBUG );
    sprintf( MsgLog , "IX                   = 0x%04X", RegIX );
    Log( MsgLog, LOG_DEBUG );
#endif
    WriteVGA( DecodeurAdresse | ROMSUP_OFF );
    ad = PackWindow( RegE, RegD, RegC, RegB, RegHL );
    Poke8Ext( RegIX, ( UBYTE )ad );
    Poke8Ext( ( USHORT )( RegIX + 1 ), ( UBYTE )( ad >> 8 ) );
    WriteVGA( DecodeurAdresse );
    ___C9();
    return( 0 );
}


int ED_03( void )
{
#ifdef USE_LOG
    Log( "ED_03 (DepkScr)", LOG_DEBUG );
    sprintf( MsgLog , "DecodeurAdresse      = %d", DecodeurAdresse );
    Log( MsgLog, LOG_DEBUG );
    sprintf( MsgLog , "PC                   = 0x%04X", RegPC );
    Log( MsgLog, LOG_DEBUG );
    sprintf( MsgLog , "HL                   = 0x%04X", RegHL );
    Log( MsgLog, LOG_DEBUG );
#endif
    WriteVGA( DecodeurAdresse | ROMSUP_OFF );
    DepackScreen( RegHL );
    WriteVGA( DecodeurAdresse );
    ___C9();
    return( 0 );
}


int ED_04( void )
{
#ifdef USE_LOG
    Log( "ED_04 (DepkWin)", LOG_DEBUG );
    sprintf( MsgLog , "DecodeurAdresse      = %d", DecodeurAdresse );
    Log( MsgLog, LOG_DEBUG );
    sprintf( MsgLog , "PC                   = 0x%04X", RegPC );
    Log( MsgLog, LOG_DEBUG );
    sprintf( MsgLog , "HL                   = 0x%04X", RegHL );
    Log( MsgLog, LOG_DEBUG );
#endif
    WriteVGA( DecodeurAdresse | ROMSUP_OFF );
    DepackWindow( RegHL );
    WriteVGA( DecodeurAdresse );
    ___C9();
    return( 0 );
}


int ED_05( void )
{
    int ad;

#ifdef USE_LOG
    Log( "ED_05 (PackWinDC)", LOG_DEBUG );
    sprintf( MsgLog , "DecodeurAdresse      = %d", DecodeurAdresse );
    Log( MsgLog, LOG_DEBUG );
    sprintf( MsgLog , "PC                   = 0x%04X", RegPC );
    Log( MsgLog, LOG_DEBUG );
    sprintf( MsgLog , "HL                   = 0x%04X", RegHL );
    Log( MsgLog, LOG_DEBUG );
    sprintf( MsgLog , "B                    = 0x%04X", RegB );
    Log( MsgLog, LOG_DEBUG );
    sprintf( MsgLog , "C                    = 0x%04X", RegC );
    Log( MsgLog, LOG_DEBUG );
    sprintf( MsgLog , "D                    = 0x%04X", RegD );
    Log( MsgLog, LOG_DEBUG );
    sprintf( MsgLog , "E                    = 0x%04X", RegE );
    Log( MsgLog, LOG_DEBUG );
    sprintf( MsgLog , "AF                   = 0x%04X", RegAF );
    Log( MsgLog, LOG_DEBUG );
    sprintf( MsgLog , "IX                   = 0x%04X", RegIX );
    Log( MsgLog, LOG_DEBUG );
#endif
    WriteVGA( DecodeurAdresse | ROMSUP_OFF );
    ad = PackWinDC( RegHL );
    Poke8Ext( RegIX, ( UBYTE )ad );
    Poke8Ext( ( USHORT )( RegIX + 1 ), ( UBYTE )( ad >> 8 ) );
    WriteVGA( DecodeurAdresse );
    ___C9();
    return( 0 );
}


int ED_06( void )
{
    int ad;

#ifdef USE_LOG
    Log( "ED_06 (PackBuff)", LOG_DEBUG );
    sprintf( MsgLog , "DecodeurAdresse      = %d", DecodeurAdresse );
    Log( MsgLog, LOG_DEBUG );
    sprintf( MsgLog , "PC                   = 0x%04X", RegPC );
    Log( MsgLog, LOG_DEBUG );
    sprintf( MsgLog , "HL                   = 0x%04X", RegHL );
    Log( MsgLog, LOG_DEBUG );
    sprintf( MsgLog , "DE                   = 0x%04X", RegDE );
    Log( MsgLog, LOG_DEBUG );
    sprintf( MsgLog , "BC                   = 0x%04X", RegBC );
    Log( MsgLog, LOG_DEBUG );
    sprintf( MsgLog , "IX                   = 0x%04X", RegIX );
    Log( MsgLog, LOG_DEBUG );
#endif
    WriteVGA( DecodeurAdresse | ROMSUP_OFF );
    ad = PackBuffer( RegHL, RegDE, RegBC );
    Poke8Ext( RegIX, ( UBYTE )ad );
    Poke8Ext( ( USHORT )( RegIX + 1 ), ( UBYTE )( ad >> 8 ) );
    WriteVGA( DecodeurAdresse );
    ___C9();
    return( 0 );
}


int ED_07( void )
{
    int ad;

#ifdef USE_LOG
    Log( "ED_07 (DepkBuff)", LOG_DEBUG );
    sprintf( MsgLog , "DecodeurAdresse      = %d", DecodeurAdresse );
    Log( MsgLog, LOG_DEBUG );
    sprintf( MsgLog , "PC                   = 0x%04X", RegPC );
    Log( MsgLog, LOG_DEBUG );
    sprintf( MsgLog , "HL                   = 0x%04X", RegHL );
    Log( MsgLog, LOG_DEBUG );
    sprintf( MsgLog , "DE                   = 0x%04X", RegDE );
    Log( MsgLog, LOG_DEBUG );
    sprintf( MsgLog , "IX                   = 0x%04X", RegIX );
    Log( MsgLog, LOG_DEBUG );
#endif
    WriteVGA( DecodeurAdresse | ROMSUP_OFF );
    ad = DepackBuffer( RegHL, RegDE );
    Poke8Ext( RegIX, ( UBYTE )ad );
    Poke8Ext( ( USHORT )( RegIX + 1 ), ( UBYTE )( ad >> 8 ) );
    WriteVGA( DecodeurAdresse );
    ___C9();
    return( 0 );
}
#endif
