#include  "types.h"
#include  "ppi.h"
#include  "crtc.h"
#include  "upd.h"
#include  "vga.h"


int ReadPort( int port )
{
    if ( ! ( port & 0x0480 ) )
        return( ReadUPD( port ) );

    if ( ! ( port & 0x0800 ) )
        return( ReadPPI( port ) );

    return( 0xFF );
}


void WritePort( int port, int val )
{
    if ( ! ( port & 0x8000 ) )
        WriteVGA( val );

    if ( ! ( port & 0x4000 ) )
        WriteCRTC( port, val );

    if ( ! ( port & 0x2000 ) )
        WriteROM( val );

    if ( ! ( port & 0x0800 ) )
        WritePPI( port, val );

    if ( ! ( port & 0x0480 ) )
        WriteUPD( port, val );
}
