/******************************************************************************/
/* Configuration pour l'archivage des diffrents lments du fichier source   */
/******************************************************************************/
// !CONFIG!=/L/* /R/* /W"* Nom : "
// Dfinition du systme       !CONFIG!=/V1!EMULATEUR CPC!
// Dfinition du sous systme  !CONFIG!=/V2!WIN-CPC!
// Dfinition du sous ensemble !CONFIG!=/V3!Accessoires!
// Dfinition du module        !CONFIG!=/V4!Gestion Configuration!
/******************************************************************************/

/********************************************************* !NAME! **************
* !./FLE!
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\Fichiers
********************************************************** !0! *****************
* ------------------------------------------------------------------------------
*          SYSTEME         |      SOUS SYSTEME       |      SOUS ENSEMBLE
* ------------------------------------------------------------------------------
*  EMULATEUR CPC           | WIN-CPC                 | Accessoires
* ------------------------------------------------------------------------------
*  Fichier     : CONFIG.C              | Version : 0.1ac
* ------------------------------------------------------------------------------
*  Date        : 05/11/2002            | Auteur  : L.DEPLANQUE
* ------------------------------------------------------------------------------
*  Description : Dcodage du fichier de configuration
*
* ------------------------------------------------------------------------------
*  Historique  :
*           Date           |         Auteur          |       Description
* ------------------------------------------------------------------------------
*  05/11/2002              | L.DEPLANQUE             | creation
* ------------------------------------------------------------------------------
*  06/01/2003              | L.DEPLANQUE             | Version 0.1t : Gestion
*                          |                         | nouvelles variables :
*                          |                         | localisation des roms
* ------------------------------------------------------------------------------
*  09/01/2003              | L.DEPLANQUE             | Version 0.1u : Gestion
*                          |                         | nouvelles variables :
*                          |                         | touches joystick
* ------------------------------------------------------------------------------
*  03/02/2003              | L.DEPLANQUE             | Version 0.1v : Gestion
*                          |                         | nouvelles variables :
*                          |                         | localisation fichiers
*                          |                         | DSK, SNA, TAP
* ------------------------------------------------------------------------------
*  06/05/2003              | L.DEPLANQUE             | Version 0.1w :
*                          |                         | Initialisation des
*                          |                         | valeurs par dfaut pour
*                          |                         | les variables contenant
*                          |                         | les scan-codes des
*                          |                         | touches mulant le
*                          |                         | joystick
* ------------------------------------------------------------------------------
*  22/01/2004              | L.DEPLANQUE             | Version 0.1x : Gestion
*                          |                         | nouvelle variable :
*                          |                         | localisation rpertoire
*                          |                         | emulation disque
* ------------------------------------------------------------------------------
*  03/02/2004              | L.DEPLANQUE             | Version 0.1y : 
*                          |                         | Suppression des
*                          |                         | fonctions de lecture
*                          |                         | des variables de type
*                          |                         | paramtres, et passage
*                          |                         | de ces variables en
*                          |                         | variables globales.
* ------------------------------------------------------------------------------
*  04/08/2004              | L.DEPLANQUE             | Version 0.1ab : 
*                          |                         | Prise en compte de
*                          |                         | 16 roms d'extensions.
* ------------------------------------------------------------------------------
*  05/10/2004              | L.DEPLANQUE             | Version 0.1ac : 
*                          |                         | Prise en compte de
*                          |                         | l'mulation de disque
*                          |                         | avec la commande
*                          |                         | avec la commande
*                          |                         | #NEW_DISC ON ou OFF
* ------------------------------------------------------------------------------
*  11/12/2004              | L.DEPLANQUE             | Version 0.1ae : 
*                          |                         | Ajout d'un flag pour
*                          |                         | utilisation de la rom
*                          |                         | pack                          |                         | avec la commande
*                          |                         | #USE_ROM_PACK ON ou OFF
* ------------------------------------------------------------------------------
********************************************************** !END! **************/


#include  <stdlib.h>
#include  <string.h>
#include  <stdio.h>

#include  "types.h"
#include  "config.h"


#define     CONFIG_NAME     "CONFIG.CPC"


/********************************************************* !NAME! **************
* Nom : FrameSkip
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Frquence de rafraichissement cran
*
********************************************************** !0! ****************/
int FrameSkip = 0;


/********************************************************* !NAME! **************
* Nom : ScreenDepth
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Nombre de couleurs cran (bits)
*
********************************************************** !0! ****************/
int ScreenDepth = 8;


/********************************************************* !NAME! **************
* Nom : SmallScreen
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Petit cran ou non
*
********************************************************** !0! ****************/
int SmallScreen = 0;


/********************************************************* !NAME! **************
* Nom : Sound
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Son ou non
*
********************************************************** !0! ****************/
int Sound = 1;


/********************************************************* !NAME! **************
* Nom : Multiface
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Multiface active ou non
*
********************************************************** !0! ****************/
int Multiface = 1;


/********************************************************* !NAME! **************
* Nom : FreqLigne
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Frquence d'une ligne cran (en Hertz)
*
********************************************************** !0! ****************/
int FreqLigne = 15625;


/********************************************************* !NAME! **************
* Nom : CycleLigne
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Nombre de cycles machines par ligne cran
*
********************************************************** !0! ****************/
int CycleLigne = 256;


/********************************************************* !NAME! **************
* Nom : LogLevel
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Niveau de logging
*
********************************************************** !0! ****************/
int LogLevel = 3;


/********************************************************* !NAME! **************
* Nom : LocRomInf
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Localisation du fichier contenant la rom infrieure du CPC
*
********************************************************** !0! ****************/
char LocRomInf[ LEN_PATH ];


/********************************************************* !NAME! **************
* Nom : LocRomExt
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Localisation des fichier contenant les roms d'extensions
*
********************************************************** !0! ****************/
char LocRomExt[ MAX_ROM_EXT ][ LEN_PATH ];


/********************************************************* !NAME! **************
* Nom : LocRomMulti
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Localisation du fichier contenant la rom de l'interface
*               Multiface II
*
********************************************************** !0! ****************/
char LocRomMulti[ LEN_PATH ];


/********************************************************* !NAME! **************
* Nom : JoyLeft
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Scan code de touche mulant joystick direction gauche
*
********************************************************** !0! ****************/
int JoyLeft = 0xFF;


/********************************************************* !NAME! **************
* Nom : JoyRight
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Scan code de touche mulant joystick direction droite
*
********************************************************** !0! ****************/
int JoyRight = 0xFF;


/********************************************************* !NAME! **************
* Nom : JoyUp
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Scan code de touche mulant joystick direction haut
*
********************************************************** !0! ****************/
int JoyUp = 0xFF;


/********************************************************* !NAME! **************
* Nom : JoyDown
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Scan code de touche mulant joystick direction bas
*
********************************************************** !0! ****************/
int JoyDown = 0xFF;


/********************************************************* !NAME! **************
* Nom : JoyFire1
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Scan code de touche mulant joystick bouton feux 1
*
********************************************************** !0! ****************/
int JoyFire1 = 0xFF;


/********************************************************* !NAME! **************
* Nom : JoyFire2
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Scan code de touche mulant joystick bouton feux 2
*
********************************************************** !0! ****************/
int JoyFire2 = 0xFF;


/********************************************************* !NAME! **************
* Nom : DirSnap
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Localisation du rpertoire contenant les fichiers snapshots
*
********************************************************** !0! ****************/
char DirSnap[ LEN_PATH ];


/********************************************************* !NAME! **************
* Nom : DirTape
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Localisation du rpertoire contenant les fichiers cassettes
*
********************************************************** !0! ****************/
char DirTape[ LEN_PATH ];


/********************************************************* !NAME! **************
* Nom : DirDisc
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Localisation du rpertoire contenant les fichiers disquettes
*
********************************************************** !0! ****************/
char DirDisc[ LEN_PATH ];


/********************************************************* !NAME! **************
* Nom : DirEmuDisc
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Localisation du rpertoire servant  l'mulation disque
*
********************************************************** !0! ****************/
char DirEmuDisc[ LEN_PATH ];


/********************************************************* !NAME! **************
* Nom : NewDiscOn
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Activation/dsactivation du module mulation disque
*
********************************************************** !0! ****************/
int NewDiscOn = 0;


/********************************************************* !NAME! **************
* Nom : RomPackOn
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Variables Globales
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Activation/dsactivation de la rom pack/dpack
*
********************************************************** !0! ****************/
int RomPackOn = 0;


/********************************************************* !NAME! **************
* Nom : GetVal
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Retourne une valeur numrique contenue dans une chaine
*
* Rsultat    : La valeur contenue dans la chaine
*
* Variables globales modifies : /
*
********************************************************** !0! ****************/
static int GetVal( char * Chaine )
{
    int val = 0;

    while ( * Chaine == ' ' )
        Chaine++;

    if ( Chaine[ 0 ] == 'O' && Chaine[ 1 ] == 'N' )
        val = 1;
    else
        val = atoi( Chaine );

    return( val );
}


/********************************************************* !NAME! **************
* Nom : GetChaine
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Retourne une valeur alphanumrique contenue dans une chaine
*
* Rsultat    : La valeur contenue dans la chaine
*
* Variables globales modifies : /
*
********************************************************** !0! ****************/
static char * GetChaine( char * Chaine )
{
    char * p;

    while ( * Chaine == ' ' )
        Chaine++;

    p = Chaine;
    while( * p && * p >= ' ' )
        p++;

    * p = 0;
    return( Chaine );
}


static void GetRomExt( char * Chaine )
{
    int NumRom = atoi( Chaine );
    if ( NumRom < MAX_ROM_EXT && NumRom >= 0 )
        strcpy( LocRomExt[ NumRom ], GetChaine( &Chaine[ 2 ] ) );
}


/********************************************************* !NAME! **************
* Nom : ReadConfig
********************************************************** !PATHS! *************
* !./V1!\!./V2!\!./V3!\!./V4!\Fonctions
********************************************************** !1! *****************
*
* Fichier     : !./FPTH\/FLE!, ligne : !./LN!
*
* Description : Lecture du fichier config. et affectation des variables
*               concernes
*
* Rsultat    : TRUE si lecture fichier config. OK, FALSE sinon
*
* Variables globales modifies : FrameSkip, ScreenDepth, SmallScreen, Sound, 
*                                Multiface, LogLevel, FreqLigne, CycleLigne,
*                                LocRomInf, LocRomExt, LocRomMulti,
*                                JoyLeft, JoyRight, JoyUp, JoyDown, JoyFire1,
*                                JoyFire2, DirSnap, DirTape, DirDisc
*
********************************************************** !0! ****************/
BOOL ReadConfig( void )
{
    static char Buffer[ 80 ];

    FILE * fp = fopen( CONFIG_NAME, "rt" );
    memset( LocRomExt, 0, sizeof( LocRomExt ) );
    if ( fp )
        {
        while( fgets( Buffer, sizeof( Buffer ), fp ) )
            {
            if ( Buffer[ 0 ] == '#' )
                {
                if ( ! strncmp( Buffer, "#FRAMESKIP", 10 ) )
                    FrameSkip = GetVal( &Buffer[ 12 ] );

                if ( ! strncmp( Buffer, "#SCREEN_DEPTH", 13 ) )
                    ScreenDepth = GetVal( &Buffer[ 15 ] );

                if ( ! strncmp( Buffer, "#SMALL_SCREEN", 13 ) )
                    SmallScreen = GetVal( &Buffer[ 15 ] );

                if ( ! strncmp( Buffer, "#SOUND", 6 ) )
                    Sound = GetVal( &Buffer[ 8 ] );

                if ( ! strncmp( Buffer, "#MULTIFACE", 10 ) )
                    Multiface = GetVal( &Buffer[ 12 ] );

                if ( ! strncmp( Buffer, "#LOG_LEVEL", 10 ) )
                    LogLevel = GetVal( &Buffer[ 12 ] );

                if ( ! strncmp( Buffer, "#FREQ_LIGNE", 11 ) )
                    FreqLigne = GetVal( &Buffer[ 13 ] );

                if ( ! strncmp( Buffer, "#CYCLE_LIGNE", 12 ) )
                    CycleLigne = GetVal( &Buffer[ 14 ] );

                if ( ! strncmp( Buffer, "#ROM_INF", 8 ) )
                    strcpy( LocRomInf, GetChaine( &Buffer[ 10 ] ) );

                if ( ! strncmp( Buffer, "#ROM_EXT", 8 ) )
                    GetRomExt( &Buffer[ 8 ] );

                if ( ! strncmp( Buffer, "#ROM_MULTI", 10 ) )
                    strcpy( LocRomMulti, GetChaine( &Buffer[ 12 ] ) );

                if ( ! strncmp( Buffer, "#JOY_LEFT", 9 ) )
                    JoyLeft = GetVal( &Buffer[ 11 ] );

                if ( ! strncmp( Buffer, "#JOY_RIGHT", 10 ) )
                    JoyRight = GetVal( &Buffer[ 12 ] );

                if ( ! strncmp( Buffer, "#JOY_UP", 7 ) )
                    JoyUp = GetVal( &Buffer[ 9 ] );

                if ( ! strncmp( Buffer, "#JOY_DOWN", 9 ) )
                    JoyDown = GetVal( &Buffer[ 11 ] );

                if ( ! strncmp( Buffer, "#JOY_FIRE1", 10 ) )
                    JoyFire1 = GetVal( &Buffer[ 12 ] );

                if ( ! strncmp( Buffer, "#JOY_FIRE2", 10 ) )
                    JoyFire2 = GetVal( &Buffer[ 12 ] );

                if ( ! strncmp( Buffer, "#DIR_SNAP", 9 ) )
                    strcpy( DirSnap, GetChaine( &Buffer[ 11 ] ) );

                if ( ! strncmp( Buffer, "#DIR_TAPE", 9 ) )
                    strcpy( DirTape, GetChaine( &Buffer[ 11 ] ) );

                if ( ! strncmp( Buffer, "#DIR_DISC", 9 ) )
                    strcpy( DirDisc, GetChaine( &Buffer[ 11 ] ) );

                if ( ! strncmp( Buffer, "#DIR_EMU_DISC", 13 ) )
                    strcpy( DirEmuDisc, GetChaine( &Buffer[ 15 ] ) );

                if ( ! strncmp( Buffer, "#NEW_DISC", 9 ) )
                    NewDiscOn = GetVal( &Buffer[ 11 ] );

                if ( ! strncmp( Buffer, "#USE_ROM_PACK", 13 ) )
                    RomPackOn = GetVal( &Buffer[ 15 ] );
                }
            }
        fclose( fp );
        return( TRUE );
        }
    return( FALSE );
}
